from django.urls import path
from . import views

app_name = 'quizzes'

urlpatterns = [
    path('', views.QuizListView.as_view(), name='quiz_list'),
    path('quiz/<slug:slug>/', views.QuizDetailView.as_view(), name='quiz_detail'),
    path('quiz/<slug:slug>/start/', views.start_quiz, name='start_quiz'),
    path('attempt/<int:attempt_id>/question/<int:question_index>/', views.attempt_question, name='attempt_question'),
    path('attempt/<int:attempt_id>/finish/', views.finish_attempt, name='finish_attempt'),
    path('leaderboard/', views.LeaderboardView.as_view(), name='leaderboard'),
    path('history/', views.UserHistoryView.as_view(), name='history'),
    path('attempt/<int:attempt_id>/', views.attempt_detail, name='attempt_detail'),
]